/*
 * Copyright (c) 2006-2021, RT-Thread Development Team
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Change Logs:
 * Date           Author       Notes
 * 2022-10-29     theo         the first version
 */
#ifndef __SYS_H__
#define __SYS_H__

/*--------------------------  CLOUD PLATFORM CONFIG BEGIN --------------------------*/
/** if you want to use cloude platform(Tencent cloud + ESP8266 + MQTT) you can use the following instructions.
 *
 * STEP 1, define macro related to the cloude platform
 *                 such as     #define WIFI_TRAINING
 *
 * STEP 2, modify the related modlue port and pin information, modlue port and pin information is defined in the gpio.h
 *                 such as     #define WIFI_RST_PIN    GET_PIN(port, pin)   ->   GET_PIN(F, 6)
 *                             #define WIFI_SET_PIN    GET_PIN(port, pin)   ->   GET_PIN(C, 0)
 */

/*#define WIFI_TRAINING*/
#define WIFI_TRAINING
#ifdef WIFI_TRAINING
#define GPIO_WIFI_SET
#define MODE_WIFI_SET
#define DEV_USING_ESP8266_WIFI
#define BOARD_USING_ESP8266_WIFI
#define APP_USING_AHT10_MQTT
#define ATK_LCD_SET
#define AHT10_ATK_LCD_SHOW
#endif

/*--------------------------  CLOUD PLATFORM CONFIG END --------------------------*/

/*--------------------------  BLUETOOTH CONFIG BEGIN --------------------------*/
/** if you want to use bluetooth(ATK-BLE01) you can use the following instructions.
 *
 * STEP 1, define macro related to the bluetooth
 *                 such as     #define BLUETOOTH_TRAINING
 *
 * STEP 2, modify the related modlue port and pin information, modlue port and pin information is defined in the gpio.h
 *                 such as     #define BLE_STA_PIN     GET_PIN(port, pin)   ->   GET_PIN(F, 6)
 *                             #define BLE_WKUP_PIN    GET_PIN(port, pin)   ->   GET_PIN(C, 0)
 */

/*#define BLUETOOTH_TRAINING*/
#ifdef BLUETOOTH_TRAINING
#define GPIO_BLUETOOTH_SET
#define MODE_BLUETOOTH_SET
#define BOARD_USING_BLE01_bluebooth
#define APP_USING_BLE01_bluebooth
#define DEV_USING_BLE01_bluebooth
#endif

/*--------------------------  BLUETOOTH CONFIG END --------------------------*/

#endif /* __SYS_H__ */
