/*
 #include <mqtt-latest/dev_pahomqtt.h>
 * Copyright (c) 2006-2021, RT-Thread Development Team
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Change Logs:
 * Date           Author       Notes
 * 2022-10-28     theo         the first version
 */

#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#include <paho_mqtt.h>
#include "dev_pahomqtt.h"
#include <modules-latest/aht10-latest/app_aht10.h>
#include <gpio.h>
#include "cJSON.h"

/* MQTT¼ */
#define MQTT_Uri    "tcp://EV1UDHPANW.iotcloud.tencentdevices.com:1883"                           /* MQTTĵַͶ˿ں */
#define ClientId    "EV1UDHPANWdev"                                                               /* ClientIdҪΨһ */
#define UserName    "EV1UDHPANWdev;12010126;EV91J;2147454847"                                     /* û */
#define PassWord    "91fe612e5275627686b7ae5cb4f762823e9fb306efa91c3afb2220b082287ae4;hmacsha256" /* ûӦ */

/* MQTTص */
MQTTClient client; /* һMQTTͻ˽ṹ */
static void mqtt_connect_callback(MQTTClient *c);                            /* MQTT ¼ص */
static void mqtt_online_callback(MQTTClient *c);                             /* MQTT ¼ص */
static void mqtt_online_callback(MQTTClient *c);                             /* MQTT ¼ص */
static void mqtt_offline_callback(MQTTClient *c);                            /* MQTT ¼ص */
static void mqtt_sub_callback(MQTTClient *c, MessageData *msg_data);         /* յĵ Topic ϢʱĻص */
static void mqtt_sub_default_callback(MQTTClient *c, MessageData *msg_data); /* ĬϵĶĻصжĵ Topic ûûصʹøĬϻص */

/**
 * created & setting MQTT
 */
int mqtt_init(void)
{
    rt_err_t rt_err;

    /* MQTTͻ˽ṹ */
    client.isconnected = 0;
    client.uri = MQTT_Uri;

    /* MQTTӲ */
    MQTTPacket_connectData condata = MQTTPacket_connectData_initializer; /* ʼ condata  */
    memcpy(&client.condata, &condata, sizeof(condata));
    client.condata.clientID.cstring = ClientId;
    client.condata.keepAliveInterval = 30;
    client.condata.cleansession = 1;
    client.condata.username.cstring = UserName;
    client.condata.password.cstring = PassWord;

    /* ΪMQTTڴ */
    client.buf_size = client.readbuf_size = 2048;
    client.buf = rt_calloc(1, client.buf_size);
    client.readbuf = rt_calloc(1, client.readbuf_size);
    if (!(client.buf && client.readbuf))
    {
        rt_kprintf("no memory for MQTT client buffer!\r\n");
        goto _exit;
    }

    /* ¼ص */
    client.connect_callback = mqtt_connect_callback;
    client.online_callback = mqtt_online_callback;
    client.offline_callback = mqtt_offline_callback;

    /* öı¼ص*/
    client.messageHandlers[0].topicFilter = SET_TOPIC;
    client.messageHandlers[0].callback = mqtt_sub_callback;
    client.messageHandlers[0].qos = QOS1;

    /* ĬϵĶ*/
    client.defaultMessageHandler = mqtt_sub_default_callback;

    /*  mqtt client */
    rt_err = paho_mqtt_start(&client);

    if(rt_err == 0)
    {
        /*  AHT10 ʪȼ */
        rt_thread_delay(3000);
        app_aht10_init();

    }

_exit:
    return RT_EOK;
}
//INIT_APP_EXPORT(mqtt_init);

/* MQTT ¼ص */
static void mqtt_connect_callback(MQTTClient *c)
{
    rt_kprintf("mqtt connect!\n");
}
/* MQTT ¼ص */
static void mqtt_online_callback(MQTTClient *c)
{
    rt_kprintf("mqtt online!\n");
}
/* MQTT ¼ص */
static void mqtt_offline_callback(MQTTClient *c)
{
    rt_kprintf("mqtt offline!\n");
}

/* յĵ Topic ϢʱĻص */
static void mqtt_sub_callback(MQTTClient *c, MessageData *msg_data)
{
    *((char *) msg_data->message->payload + msg_data->message->payloadlen) = '\0';
//    rt_kprintf("Receive topic: %.*s, message data:\r\n", msg_data->topicName->lenstring.len, msg_data->topicName->lenstring.data);
//    rt_kprintf("%.*s\r\n", msg_data->message->payloadlen, (char *) msg_data->message->payload);

    /* ȡյĵ Topic Ϣ */
//    rt_kprintf("%s\r\n", (char *) msg_data->message->payload);

    /* cJSON ݴ */
    cJSON *cjson_message = NULL;
//    cJSON* cjson_method = NULL;
    cJSON *cjson_params = NULL;
    cJSON *cjson_params_beep = NULL;

    /* JSON */
    cjson_message = cJSON_Parse((const char *) msg_data->message->payload);
    if(cjson_message == NULL)
    {
        rt_kprintf("cJSON message failed\n");
        return;
    }

    /* θȡ JSON ݣֵԣ */
//    cjson_method = cJSON_GetObjectItem(cjson_message, "method");
//    rt_kprintf("method: %s\n", cjson_method->valuestring);

    /* Ƕ JSON  */
    cjson_params = cJSON_GetObjectItem(cjson_message, "params");
    if(cjson_params != NULL)
    {
        cjson_params_beep = cJSON_GetObjectItem(cjson_params, "beep");
        rt_kprintf("beep: %d\n", cjson_params_beep->valueint);

        /* JSON ݻص */
        if (cjson_params_beep->valueint == 1)
        {
            BEEP_ON;
        }
        else
        {
            BEEP_OFF;
        }

        cJSON_free(cjson_params_beep);
    }

    /* ͷڴ */
    cJSON_Delete(cjson_message);
}

/* ĬϵĶĻصжĵ Topic ûûصʹøĬϻص */
static void mqtt_sub_default_callback(MQTTClient *c, MessageData *msg_data)
{
    *((char *) msg_data->message->payload + msg_data->message->payloadlen) = '\0';
    rt_kprintf("Receive topic: %.*s, message data:\r\n", msg_data->topicName->lenstring.len, msg_data->topicName->lenstring.data);
    rt_kprintf("%.*s\r\n", msg_data->message->payloadlen, (char *) msg_data->message->payload);
}

/* Ѷmqttòο:
 * https://blog.csdn.net/weixin_45381001/article/details/123221328
 * https://cloud.tencent.com/document/product/634/14630
 * https://cloud.tencent.com/document/product/634/32546
 */




