/*
 * Copyright (c) 2006-2022, RT-Thread Development Team
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Change Logs:
 * Date           Author       Notes
 * 2022-10-25     RT-Thread    first version
 * 2022-10-25     theo         add esp8266
 * 2022-10-27     theo         add aht10
 * 2022-10-28     theo         update aht10
 * 2022-10-29     theo         add cloud and bluetooth
 * 2022-11-11     theo         add atk-tftlcd
 */
#if 1
#include <rtthread.h>
#include <rtdevice.h>
#include "drv_common.h"

#define DBG_TAG "main"
#define DBG_LVL DBG_LOG
#include <rtdbg.h>

#include <mqtt-latest/dev_pahomqtt.h>
#include <bluetooth-v1.2.3/app_bluetooth.h>
#include <tftlcd-latest/lcd.h>
#include <gpio.h>
#include <sys.h>

static void system_init(void); /* System Initialization */
static void gpio_init(void); /* GPIO Initialization */

int main(void)
{
    /* System Initialization */
    system_init();

    return RT_EOK;
}

/* System Initialization */
static void system_init(void)
{
    gpio_init();

#ifdef APP_USING_AHT10_MQTT
    rt_kprintf("\n============================ NETWORK Training ============================\n");
    mqtt_init();
#else
    rt_kprintf("\n================================== Info ==================================\n");
    rt_kprintf("Please modify sys.h to enabled the network training or bluetooth training!!\n\n");
    rt_kprintf("Note: if you need the LCD show, please define macro related to the LCD in \nsys.h, such as #define ATK_LCD_SET...\n\n");
    rt_kprintf("Maintainer: <theo@theotsang.xyz>\nUpdated:    2022-11-16\n\n");
#endif

#ifdef APP_USING_BLE01_bluebooth
    rt_kprintf("\n=========================== BLUETOOTH Training ===========================\n");
    app_bluetooth_init();
#endif
}

/* GPIO Initialization */
void gpio_init(void)
{
    /* LEDܽΪģʽ */
    rt_pin_mode(LED0_PIN, PIN_MODE_OUTPUT);
    rt_pin_mode(LED1_PIN, PIN_MODE_OUTPUT);

    /* BEEPܽΪģʽ */
    rt_pin_mode(BEEP_PIN, PIN_MODE_OUTPUT);

#ifdef BOARD_USING_BLE01_bluebooth
    /* BLE_WKUPΪģʽ */
    rt_pin_mode(BLE_WKUP_PIN, PIN_MODE_OUTPUT);

    /* BLE_STAΪͨģʽ */
    rt_pin_mode(BLE_STA_PIN, PIN_MODE_INPUT_PULLDOWN);

    /* Ĭ״̬ */
    BLE_WKUP_H;
#endif
    LED0_OFF;
    LED1_OFF;
    BEEP_OFF;
}
#else

#include <rtthread.h>

#define DBG_TAG "main"
#define DBG_LVL DBG_LOG
#include <rtdbg.h>

#include <tftlcd-latest/lcd.h>

int main(void)
{
    u8 x=0;
    u8 lcd_id[12];              //LCD IDַ

    LCD_Init();                     //ʼLCD FSMCӿ
    POINT_COLOR=RED;                //ɫɫ
    rt_sprintf((char*)lcd_id,"LCD ID:%04X",lcddev.id);//LCD IDӡlcd_id顣
    while(1)
    {
        switch(x)
        {
            case 0:LCD_Clear(WHITE);break;
            case 1:LCD_Clear(BLACK);break;
            case 2:LCD_Clear(BLUE);break;
            case 3:LCD_Clear(RED);break;
            case 4:LCD_Clear(MAGENTA);break;
            case 5:LCD_Clear(GREEN);break;
            case 6:LCD_Clear(CYAN);break;
            case 7:LCD_Clear(YELLOW);break;
            case 8:LCD_Clear(BRRED);break;
            case 9:LCD_Clear(GRAY);break;
            case 10:LCD_Clear(LGRAY);break;
            case 11:LCD_Clear(BROWN);break;
        }
        POINT_COLOR=RED;
        LCD_ShowString(30,40,210,24,24,"Explorer STM32F4");
        LCD_ShowString(30,70,200,16,16,"TFTLCD TEST");
        LCD_ShowString(30,90,200,16,16,"ATOM@ALIENTEK");
        LCD_ShowString(30,110,200,16,16,lcd_id);        //ʾLCD ID
        LCD_ShowString(30,130,200,12,12,"2017/4/8");
        x++;
        if(x==12)x=0;
        rt_thread_delay(1000);
    }
}
#endif
