/*
 * Copyright (c) 2006-2021, RT-Thread Development Team
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Change Logs:
 * Date           Author       Notes
 * 2022-10-29     theo         the first version
 */
#ifndef __GPIO_H__
#define __GPIO_H__

#include <rtthread.h>
#include <rtdevice.h>
#include "drv_common.h"

#include <sys.h>

/* GPIO */
#define LED0_PIN                GET_PIN(F, 9)
#define LED1_PIN                GET_PIN(F, 10)

#define BEEP_PIN                GET_PIN(F, 8)

#define LCD_LED                 GET_PIN(B, 15)   /* LCD PB15 */

#ifdef GPIO_BLUETOOTH_SET
#define BLE_STA_PIN             GET_PIN(F, 6)
#define BLE_WKUP_PIN            GET_PIN(C, 0)
#endif

#ifdef GPIO_WIFI_SET
#define WIFI_RST_PIN            GET_PIN(F, 6)   /* ATK-ESP-01 λţ͵ƽЧ */
#define WIFI_SET_PIN            GET_PIN(C, 0)   /* ATK-ESP-01 ţ͵ƽǹ̼дģʽߵƽģʽ  */
#endif

#define LED0_ON                 rt_pin_write(LED0_PIN, PIN_LOW);
#define LED0_OFF                rt_pin_write(LED0_PIN, PIN_HIGH);
#define LED1_ON                 rt_pin_write(LED1_PIN, PIN_LOW);
#define LED1_OFF                rt_pin_write(LED1_PIN, PIN_HIGH);

#define BEEP_ON                 rt_pin_write(BEEP_PIN, PIN_HIGH);
#define BEEP_OFF                rt_pin_write(BEEP_PIN, PIN_LOW);

#define LCD_LED_H              rt_pin_write(LCD_LED, PIN_HIGH);

#ifdef MODE_BLUETOOTH_SET
#define BLE_WKUP_H              rt_pin_write(BLE_WKUP_PIN, PIN_HIGH);
#define BLE_WKUP_L              rt_pin_write(BLE_WKUP_PIN, PIN_LOW);
#endif

#ifdef MODE_WIFI_SET
#define WIFI_RST_H              rt_pin_write(WIFI_RST_PIN, PIN_HIGH);
#define WIFI_RST_L              rt_pin_write(WIFI_RST_PIN, PIN_LOW);
#define WIFI_SET_H              rt_pin_write(WIFI_SET_PIN, PIN_HIGH);
#define WIFI_SET_L              rt_pin_write(WIFI_SET_PIN, PIN_LOW);
#endif

#endif /* __GPIO_H__ */
