# MQTT 软件包介绍

[Paho MQTT](http://www.eclipse.org/paho/downloads.php) 是 Eclipse 实现的 MQTT 协议的客户端，本软件包是在 Eclipse [paho-mqtt](https://github.com/eclipse/paho.mqtt.embedded-c) 源码包的基础上设计的一套 MQTT 客户端程序。

## 文件目录结构

```c 
pahomqtt
├───docs 
│   └───figures                     // 文档使用图片
│   │   api.md                      // API 使用说明
│   │   introduction.md             // 介绍文档
│   │   principle.md                // 实现原理
│   │   README.md                   // 文档结构说明  
│   │   samples.md                  // 软件包示例
│   │   user-guide.md               // 使用说明
│   └───version.md                  // 版本
├───MQTTClient-RT                   // 移植文件
├───MQTTPacket                      // 源文件
├───samples                         // 示例代码
│       mqtt_sample.c               // 软件包应用示例代码
├───tests                           // mqtt 功能测试程序
│   LICENSE                         // 软件包许可证
│   README.md                       // 软件包使用说明
└───SConscript                      // RT-Thread 默认的构建脚本
```

## RT-Thread  软件包功能特点

RT-Thread MQTT 客户端功能特点如下：

- 断线自动重连

    RT-Thread MQTT 软件包实现了断线重连机制，在断网或网络不稳定导致连接断开时，会维护登陆状态，重新连接，并自动重新订阅 Topic。提高连接的可靠性，增加了软件包的易用性。

- pipe 模型，非阻塞 API

    降低编程难度，提高代码运行效率，适用于高并发数据量小的情况。

- 事件回调机制

    在建立连接、收到消息或者断开连接等事件时，可以执行自定义的回调函数。

- TLS 加密传输

    MQTT 可以采用 TLS 加密方式传输，保证数据的安全性和完整性 。

## MQTT 简述

MQTT（Message Queuing Telemetry Transport，消息队列遥测传输协议），是一种基于发布/订阅（publish/subscribe）模式的“轻量级”通讯协议，该协议构建于 TCP/IP 协议上，由 IBM 在1999年发布。MQTT 最大优点在于，可以以极少的代码和有限的带宽，为连接远程设备提供实时可靠的消息服务。作为一种低开销、低带宽占用的即时通讯协议，使其在物联网、小型设备、移动应用等方面有较广泛的应用。

MQTT 是一个基于客户端-服务器的消息发布/订阅传输协议。MQTT 协议是轻量、简单、开放和易于实现的，这些特点使它适用范围非常广泛。在很多情况下，包括受限的环境中，如：机器与机器（M2M）通信和物联网（IoT）。其在，通过卫星链路通信传感器、偶尔拨号的医疗设备、智能家居、及一些小型化设备中已广泛使用。

## MQTT  功能介绍

MQTT 协议运行在 TCP/IP 或其他网络协议之上，它将建立客户端到服务器的连接，提供两者之间的一个有序的、无损的、基于字节流的双向传输。当应用数据通过 MQTT 网络发送时， MQTT 会把与之相关的服务质量（QoS）和主题名（Topic）相关连，其特点包括：

1. 使用发布/订阅消息模式，它提供了一对多消息分发，以实现与应用程序的解耦。
2. 对负载内容屏蔽的消息传输机制。
3. 对传输消息有三种服务质量（QoS）：
	1. 最多一次，这一级别会发生消息丢失或重复，消息发布依赖于底层 TCP/IP 网络。即：<=1
	2. 至少一次，这一级别会确保消息到达，但消息可能会重复。即：>=1
	3. 只有一次，确保消息只有一次到达。即：＝1。在一些要求比较严格的计费系统中，可以使用此级别。
4. 数据传输和协议交换的最小化（协议头部只有2字节），以减少网络流量。
5. 通知机制，异常中断时通知传输双方。

### MQTT 客户端

一个使用MQTT协议的应用程序或者设备，它总是建立到服务器的网络连接。客户端可以：

- 与服务器建立连接
- 发布其他客户端可能会订阅的信息
- 接收其它客户端发布的消息
- 退订已订阅的消息

### MQTT 服务器

MQTT服务器以称为“消息代理”（Broker），可以是一个应用程序或一台设备。它是位于消息发布者和订阅者之间，它可以：

- 接受来自客户的网络连接
- 接收客户发布的应用信息
- 处理来自客户端的订阅和退订请求
- 向订阅的客户转发应用程序消息

### MQTT 协议中的方法

MQTT协议中定义了一些方法（也被称为动作）， 用来表示对确定资源所进行操作。 这个资源可以代表预先存在的数据或动态生成数据，这取决于服务器的实现。通常来说，资源指服务器上的文件或输出。

- Connect：等待与服务器建立连接。
- Disconnect：等待 MQTT 客户端完成所做的工作，并与服务器断开 TCP/IP 会话。
- Subscribe：等待完成订阅。
- UnSubscribe：等待服务器取消客户端的一个或多个 Topics 订阅。
- Publish：MQTT 客户端发送消息请求，发送完成后返回应用程序线程。

### MQTT 协议中的订阅、主题、会话

- 订阅（Subscription）

    订阅包含主题筛选器（Topic Filter）和最大服务质量（QoS）。订阅会与一个会话（Session）关联。一个会话可以包含多个订阅。每一个会话中的每个订阅都有一个不同的主题筛选器。

- 会话（Session）

    每个客户端与服务器建立连接后就是一个会话，客户端和服务器之间有状态交互。会话存在于一个网络之间，也可能在客户端和服务器之间跨越多个连续的网络连接。

- 主题名（Topic Name）

    连接到一个应用程序消息的标签，该标签与服务器的订阅相匹配。服务器会将消息发送给订阅所匹配标签的每个客户端。

- 主题筛选器（Topic Filter）

    一个对主题名通配符筛选器，在订阅表达式中使用，表示订阅所匹配到的多个主题。

- 负载（Payload）

    消息订阅者所具体接收的内容。

- 应用消息 Application Message

    MQTT协议通过网络传输应用数据。应用消息通过MQTT传输时，它们有关联的服务质量（QoS）和主题（Topic）。

- 控制报文 MQTT Control Packet 

    通过网络连接发送的信息数据包。MQTT规范定义了十四种不同类型的控制报文，其中一个（PUBLISH报文）用于传输应用消息。
