#ifndef __LCD_H
#define __LCD_H		

#include <sys.h>

#ifdef ATK_LCD_SET
#include <rtthread.h>
#include <rtdevice.h>
#include "drv_common.h"

#include "stdlib.h" 
#include "stm32f4xx_hal.h"
#include "parameter.h"
#include "gpio.h"

//////////////////////////////////////////////////////////////////////////////////	 
//ֻѧϰʹãδɣκ;
//ALIENTEK STM32
//2.8/3.5/4.3/7 TFTҺ	  
//֧ICͺŰ:ILI9341/NT35310/NT35510/SSD1963		    
//ԭ@ALIENTEK
//̳:www.openedv.com
//:2017/4/8
//汾V4.2
//ȨУؾ
//Copyright(C) ӿƼ޹˾ 2014-2024
//All rights reserved	
//******************************************************************************* 
//޸˵
//V4.0 20211111
//1ȥ󲿷ֲIC֧
//2ST7789IC֧
//3ŻṹԴ룩
//V4.1 20211208
//޸NT5510 IDȡʽ,ΪȷԿ,ȻȡC500C501,ӶȡȷID(0X5510)
//V4.2 20211222
//1޸FSMCٶȣ7789ʾOV2640
//2NT5510 IDȡC501ָSSD1963󴥷λȡID⣬ʱ
//////////////////////////////////////////////////////////////////////////////////	 

extern SRAM_HandleTypeDef TFTSRAM_Handler;    //SRAM(ڿLCD)

//LCDҪ
typedef struct  
{		 	 
	u16 width;			//LCD 
	u16 height;			//LCD ߶
	u16 id;				//LCD ID
	u8  dir;			//ƣ01	
	u16	wramcmd;		//ʼдgramָ
	u16 setxcmd;		//xָ
	u16 setycmd;		//yָ 
}_lcd_dev; 	  

//LCD
extern _lcd_dev lcddev;	//LCDҪ
//LCDĻɫͱɫ	   
extern u32  POINT_COLOR;//ĬϺɫ    
extern u32  BACK_COLOR; //ɫ.ĬΪɫ


//////////////////////////////////////////////////////////////////////////////////	 
//-----------------MCU LCD˿ڶ---------------- 
// gpio.h

//LCDַṹ
typedef struct
{
	vu16 LCD_REG;
	vu16 LCD_RAM;
} LCD_TypeDef;
//ʹNOR/SRAM Bank1.sector4,ַλHADDR[27,26]=11 A6Ϊ 
//עʱSTM32ڲһλ! 111 1110=0X7E			    
#define LCD_BASE        ((u32)(0x6C000000 | 0x0000007E))
#define LCD             ((LCD_TypeDef *) LCD_BASE)
//////////////////////////////////////////////////////////////////////////////////
	 
//ɨ跽
#define L2R_U2D  0 		//,ϵ
#define L2R_D2U  1 		//,µ
#define R2L_U2D  2 		//ҵ,ϵ
#define R2L_D2U  3 		//ҵ,µ

#define U2D_L2R  4 		//ϵ,
#define U2D_R2L  5 		//ϵ,ҵ
#define D2U_L2R  6 		//µ,
#define D2U_R2L  7		//µ,ҵ	 

#define DFT_SCAN_DIR  L2R_U2D  //Ĭϵɨ跽

//ɫ
#define WHITE         	 0xFFFF
#define BLACK         	 0x0000	  
#define BLUE         	 0x001F  
#define BRED             0XF81F
#define GRED 			 0XFFE0
#define GBLUE			 0X07FF
#define RED           	 0xF800
#define MAGENTA       	 0xF81F
#define GREEN         	 0x07E0
#define CYAN          	 0x7FFF
#define YELLOW        	 0xFFE0
#define BROWN 			 0XBC40 //ɫ
#define BRRED 			 0XFC07 //غɫ
#define GRAY  			 0X8430 //ɫ
//GUIɫ

#define DARKBLUE      	 0X01CF	//ɫ
#define LIGHTBLUE      	 0X7D7C	//ǳɫ  
#define GRAYBLUE       	 0X5458 //ɫ
//ɫΪPANELɫ 
 
#define LIGHTGREEN     	 0X841F //ǳɫ
//#define LIGHTGRAY        0XEF5B //ǳɫ(PANNEL)
#define LGRAY 			 0XC618 //ǳɫ(PANNEL),屳ɫ

#define LGRAYBLUE        0XA651 //ǳɫ(мɫ)
#define LBBLUE           0X2B12 //ǳɫ(ѡĿķɫ)
	    															  
void LCD_Init(void);													   	//ʼ
void LCD_DisplayOn(void);													//ʾ
void LCD_DisplayOff(void);													//ʾ
void LCD_Clear(u32 Color);	 												//
void LCD_SetCursor(u16 Xpos, u16 Ypos);										//ù
void LCD_DrawPoint(u16 x,u16 y);											//
void LCD_Fast_DrawPoint(u16 x,u16 y,u32 color);								//ٻ
u32  LCD_ReadPoint(u16 x,u16 y); 											// 
void LCD_Draw_Circle(u16 x0,u16 y0,u8 r);						 			//Բ
void LCD_DrawLine(u16 x1, u16 y1, u16 x2, u16 y2);							//
void LCD_DrawRectangle(u16 x1, u16 y1, u16 x2, u16 y2);		   				//
void LCD_Fill(u16 sx,u16 sy,u16 ex,u16 ey,u32 color);		   				//䵥ɫ
void LCD_Color_Fill(u16 sx,u16 sy,u16 ex,u16 ey,u16 *color);				//ָɫ
void LCD_ShowChar(u16 x,u16 y,u8 num,u8 size,u8 mode);						//ʾһַ
void LCD_ShowNum(u16 x,u16 y,u32 num,u8 len,u8 size);  						//ʾһ
void LCD_ShowxNum(u16 x,u16 y,u32 num,u8 len,u8 size,u8 mode);				//ʾ 
void LCD_ShowString(u16 x,u16 y,u16 width,u16 height,u8 size,u8 *p);		//ʾһַ,12/16
void LCD_ShowFontHZ(u16 x, u16 y, u8 *cn, u16 font_color, u16 back_color);  //ʾ

void LCD_WriteReg(u16 LCD_Reg, u16 LCD_RegValue);
u16 LCD_ReadReg(u16 LCD_Reg);
void LCD_WriteRAM_Prepare(void);
void LCD_WriteRAM(u16 RGB_Code);
void LCD_SSD_BackLightSet(u8 pwm);							//SSD1963 
void LCD_Scan_Dir(u8 dir);									//ɨ跽
void LCD_Display_Dir(u8 dir);								//Ļʾ
void LCD_Set_Window(u16 sx,u16 sy,u16 width,u16 height);	//ô					   						   																			 
//LCDֱ
#define SSD_HOR_RESOLUTION		800		//LCDˮƽֱ
#define SSD_VER_RESOLUTION		480		//LCDֱֱ
//LCD
#define SSD_HOR_PULSE_WIDTH		1		//ˮƽ
#define SSD_HOR_BACK_PORCH		46		//ˮƽǰ
#define SSD_HOR_FRONT_PORCH		210		//ˮƽ

#define SSD_VER_PULSE_WIDTH		1		//ֱ
#define SSD_VER_BACK_PORCH		23		//ֱǰ
#define SSD_VER_FRONT_PORCH		22		//ֱǰ
//¼Զ
#define SSD_HT	(SSD_HOR_RESOLUTION+SSD_HOR_BACK_PORCH+SSD_HOR_FRONT_PORCH)
#define SSD_HPS	(SSD_HOR_BACK_PORCH)
#define SSD_VT 	(SSD_VER_RESOLUTION+SSD_VER_BACK_PORCH+SSD_VER_FRONT_PORCH)
#define SSD_VPS (SSD_VER_BACK_PORCH)
#endif
#endif  
	 
	 



