/*
 * Copyright (c) 2006-2021, RT-Thread Development Team
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Change Logs:
 * Date           Author       Notes
 * 2022-10-28     theo         the first version
 */

#include "sensor_asair_aht10.h"

/* AHT10 */
#define AHT10_I2C_BUS  "i2c1"

static int rt_hw_aht10_port(void)
{
    struct rt_sensor_config cfg;

    cfg.intf.dev_name = AHT10_I2C_BUS;
    cfg.intf.user_data = (void *) AHT10_I2C_ADDR;

    rt_hw_aht10_init("aht10", &cfg);

    return RT_EOK;
}
INIT_ENV_EXPORT(rt_hw_aht10_port);



/* ο
 * https://gitee.com/RT-Thread-Mirror/aht10/blob/master/README_ZH.md
 */

/* Readme:
 * aht10 ʼ int rt_hw_aht10_init(const char *name, struct rt_sensor_config *cfg)Ҫû
 * ҪɵĹǣ豸úͳʼעӦĴ豸 aht10 豸ע
 */

