/*
 * Copyright (c) 2006-2021, RT-Thread Development Team
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Change Logs:
 * Date           Author       Notes
 * 2022-10-27     theo         the first version
 * 2022-11-11     theo         add the atk-tftlcd show
 */

#include <stdlib.h>
#include <string.h>
#include <stdint.h>

#include "aht10.h"
#include "app_aht10.h"
#include <paho_mqtt.h>
#include <mqtt-latest/dev_pahomqtt.h>
#include <tftlcd-latest/lcd.h>
#include <gpio.h>
#include <sys.h>

/* AHT10 */
extern struct aht10_device *temp_humi_dev;

/* MQTT */
extern MQTTClient client; /* һMQTTͻ˽ṹ */

/* Ϣ */
#define THREAD_STACK_SIZE         1024
#define THREAD_PRIORITY           10
#define THREAD_TIMESLICE          10

static rt_thread_t aht10_thread = RT_NULL; /* ߳̿ƿ => ֤ */
static void aht10_thread_entry(void *parameter);

float humidity = 0, temperature = 0;

int app_aht10_init(void)
{
    rt_err_t rt_err;

    /* ʪȲɼ̣߳ aht10_thread aht10_thread_entry */
    aht10_thread = rt_thread_create("aht10_thread",     /* ̵߳ */
                                    aht10_thread_entry, /* ߳ں */
                                    RT_NULL,            /* ߳ںĲ   */
                                    THREAD_STACK_SIZE,  /* ߳ջСλֽ  */
                                    THREAD_PRIORITY,    /* ̵߳ȼֵԽСȼԽ */
                                    THREAD_TIMESLICE);  /* ̵߳ʱƬС */

    /* ߳̿ƿ飬߳ */
    if (aht10_thread != RT_NULL)
        rt_err = rt_thread_startup(aht10_thread);
    else
        rt_kprintf("aht10 thread create failed! \n");

    /* ж߳Ƿ񴴽ɹ */
    if (rt_err != RT_EOK)
        rt_kprintf("aht10 thread startup error! \n");

    return RT_EOK;
}
//INIT_APP_EXPORT(app_aht10_init);

/* ʪȲɼ߳ں*/
static void aht10_thread_entry(void *parameter)
{
    /* ʼ */
    char msg_buf[20];

#ifdef AHT10_ATK_LCD_SHOW
    u32 humidity_show_1, humidity_show_2;
    uint8_t *temperature_show_1, temperature_show_2;

    LCD_Init(); /* ʼLCD FSMCӿ */
    POINT_COLOR=RED; /* ɫɫ */

    LCD_ShowString(20, 240, 210, 24, 24, "humidity   : ");
    LCD_ShowString(208, 240, 210, 24, 24, ".");
    LCD_ShowString(240, 240, 210, 24, 24, "%");

    LCD_ShowString(20, 300, 210, 24, 24, "temperature: ");
    LCD_ShowString(208, 300, 210, 24, 24, ".");
    LCD_ShowString(240, 300, 210, 24, 24, "C");
#endif

    for(;;)
    {
        /* read humidity ɼʪ */
        humidity = aht10_read_humidity(temp_humi_dev);
//        rt_kprintf("humidity   : %d.%d %%\n", (int) humidity, (int) (humidity * 10) % 10); /* former is integer and behind is decimal */
#ifdef AHT10_ATK_LCD_SHOW
        humidity_show_1 = (int) humidity;
        humidity_show_2 = (int) (humidity * 10) % 10;
        LCD_ShowNum(184, 240, humidity_show_1, 2, 24);
        LCD_ShowNum(218, 240, humidity_show_2, 1, 24);
#endif

        /* read temperature ɼ¶ */
        temperature = aht10_read_temperature(temp_humi_dev);
//        rt_kprintf("temperature: %d.%d C\n", (int) temperature, (int) (temperature * 10) % 10); /* former is integer and behind is decimal */
#ifdef AHT10_ATK_LCD_SHOW
        temperature_show_1 = (int) temperature;
        temperature_show_2 = (int) (temperature * 10) % 10;
        LCD_ShowNum(184, 300, temperature_show_1, 2, 24);
        LCD_ShowNum(218, 300, temperature_show_2, 1, 24);
#endif

        /* send humidity and temperature to tencent cloud */
        rt_sprintf(msg_buf, "{\"method\":\"report\",\"clientToken\":\"12\",\"params\":{\"humidity_value\":%d,\"temperature_value\":%d}}", (int) humidity, (int) temperature);
        paho_mqtt_publish(&client, QOS1, POST_TOPIC, msg_buf);

        LED1_ON;
        rt_thread_delay(500);
        LED1_OFF;
    }
}

/* ο
 * https://blog.csdn.net/qq_38113006/article/details/105349975?ops_request_misc=%257B%2522request%255Fid%2522%253A%2522166687812816782388080836%2522%252C%2522scm%2522%253A%252220140713.130102334.pc%255Fall.%2522%257D&request_id=166687812816782388080836&biz_id=0&utm_medium=distribute.pc_search_result.none-task-blog-2~all~first_rank_ecpm_v1~rank_v31_ecpm-7-105349975-null-null.142
 * https://zhuanlan.zhihu.com/p/377252749
 * https://www.rt-thread.org/document/site/#/rt-thread-version/rt-thread-standard/programming-manual/device/i2c/i2c?id=i2c-%e6%80%bb%e7%ba%bf%e8%ae%be%e5%a4%87%e4%bd%bf%e7%94%a8%e7%a4%ba%e4%be%8b
 */
