/*
 * Copyright (c) 2006-2021, RT-Thread Development Team
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Change Logs:
 * Date           Author       Notes
 * 2022-10-22     theo         the first version
 */

#include <gpio.h>
#include <sys.h>

#ifdef DEV_USING_BLE01_bluebooth
#define DBG_TAG "app_bluetooth"
#define DBG_LVL DBG_LOG
#include <rtdbg.h>

/*  */
#define UART_SET                "uart3"

static rt_device_t serial; /* 豸 */
struct serial_configure uart3_config = RT_SERIAL_CONFIG_DEFAULT; /* ʼò */
static rt_err_t uart_input(rt_device_t dev, rt_size_t size); /* ݻص */

/* ź */
struct rt_semaphore sem;

/* ߳ */
#define THREAD_STACK_SIZE       1024
#define THREAD_PRIORITY         10
#define THREAD_TIMESLICE        5

static rt_thread_t uart3_thread = RT_NULL; /* ߳̿ƿ => ֤ */
static void uart3_thread_entry(void *parameter); /* ̻߳صڽжϣ */

int app_bluetooth_init(void)
{
    rt_err_t ret = 0;
    const char * str1[] = { "+++a", "AT+NAME=19010204\r\n", "AT+RESET\r\n" }; /* һάԪֻǵַȴַԣһַ飨ַָ飩ԪΪַ ַָ  */
    const char * str2[] = { "+++a", "AT+MODE=S\r\n", "AT+NAME?\r\n"};

    /* Ҵ豸 */
    serial = rt_device_find(UART_SET);
    if (serial == NULL)
    {
        LOG_E("find %s failed!\n", UART_SET);
        return RT_ERROR;
    }

    /* жϽռѯģʽ򿪴豸 */
    ret = rt_device_open(serial, RT_DEVICE_FLAG_INT_RX | RT_DEVICE_OFLAG_RDWR);
    if (ret < 0)
    {
        LOG_E("open %s failed!\n", UART_SET);
        return ret;
    }

    /* ƴ豸 */
    rt_device_control(serial, RT_DEVICE_CTRL_CONFIG, (void *) &uart3_config);

    /* ýջص */
    rt_device_set_rx_indicate(serial, uart_input);

    /* ʼź */
    rt_sem_init(&sem, "sem_A", 0, RT_IPC_FLAG_FIFO); /* RT_IPC_FLAG_FIFO Ƚȳģʽ */

    /* ߳A */
    uart3_thread = rt_thread_create("thread_A",          //̵߳
                                    uart3_thread_entry,  //߳ں
                                    RT_NULL,             //߳ںĲ
                                    THREAD_STACK_SIZE,   //ջС
                                    THREAD_PRIORITY,     //̵߳ȼ
                                    THREAD_TIMESLICE);   //ʱƬ
    /* ߳̿ƿ飬߳ */
    if (uart3_thread != RT_NULL)
        rt_thread_startup(uart3_thread);

    /* ַ */
    int i, len;
    len = sizeof(str1) / sizeof(str1[0]);
    for (i = 0; i < len; i++)
    {
        rt_thread_delay(1000);
        rt_device_write(serial, 0, str1[i], rt_strlen(str1[i]));
    }
    rt_thread_delay(1000);
    len = sizeof(str2) / sizeof(str2[0]);
    for (i = 0; i < len; i++)
    {
        rt_thread_delay(1000);
        rt_device_write(serial, 0, str2[i], rt_strlen(str2[i]));
    }
//    rt_device_write(serial, 0, str[0], rt_strlen(str[0]));

    return RT_EOK;
}

/* ݻص */
static rt_err_t uart_input(rt_device_t dev, rt_size_t size)
{
    /* ]xȡʹQ̹xȡӡ */
    rt_sem_release(&sem); /* ͷһźźָ̹߳*/

    return RT_EOK;
}

/* ̻߳صڽжϣ */
static void uart3_thread_entry(void *parameter)
{
    const char * buffer;
    const char * flag[] = { "LED1:ON", "LED1:OFF" };

    for (;;)
    {
        while (rt_device_read(serial, 0, &buffer, 1) != 1) /* ÿζһsize => һַ͕|lһД */
        {
            rt_sem_take(&sem, RT_WAITING_FOREVER); /* ÿյһsizeͫ@ȡһ̖ */
        }

        /*  */
        rt_kprintf("%c", buffer);
        LED0_ON;
        rt_thread_delay(10);
        LED0_OFF;

        /* LED1 control */
//        LOG_E("%d", rt_strcmp(buffer, flag[0]));
        if (rt_strcmp(buffer, flag[0]) == 12) /* Ϊʲô 12? ȥһעֻͣ 1 鿴ֵ */
        {
            rt_device_write(serial, 0, flag[0], rt_strlen(flag[0]));
            LED1_ON;
        }
        else
        {
            rt_device_write(serial, 0, flag[1], rt_strlen(flag[1]));
            LED1_OFF;
        }
    }
}
#endif
